/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * firmware.h                                                          *
   * Christian Zurhorst, BID R&D, 11. Sep. 1997                          *
   *                                                                     *
   * defines common declarations for firmware and CAPI                   *
   *                                                                     *
   ***********************************************************************

   Note:

   You should never need to incude this file yourself. Include typedefs.h
   for CAPI or std_types.h for firmware instead.
*/


#ifndef __FIRMWARE_H
#define __FIRMWARE_H


#ifndef TYPEDEFS_H_INCLUDED
#  ifndef __STD_TYPES_H

   You should not include this file by yourself

#  endif
#endif


/* The kind of communication ports the Host talks to the BEST */
CLI typedef enum {
  B_PORT_RS232,
  B_PORT_PARALLEL,
  B_PORT_FASTHIF,
  B_PORT_PCI_CONF,
  B_PORT_PCI_IO,
  B_PORT_OFFLINE,
  B_PORT_COUNT,		/* for internal use only */
  B_PORT_CURRENT,
  B_PORT_UNKNOWN=255		/* for svp use */
} b_porttype;


/* The firmware view */
/* !! NOTE: keep the PORTID enum coherent with port list in error.c (CAPI) */
/* !! ALSO; these enums are used as indexes into the Port Regfile 0x10 */

typedef enum {
    PORTID_UNKNOWN,
    PORTID_DEBUG,   /* NEVER (EVER) change the index of PORTID_DEBUG !! */
    PORTID_SERIAL,
    PORTID_PARALLEL,
    PORTID_PCI,
    PORTID_LAN,
    PORTID_COUNT
} PORTID;


/* ---------------------------------------------------------------
   definitions for error handling
   --------------------------------------------------------------- */

#define B_ERROR_MSGLENGTH	1024
#define B_LASTERR_STRING	 256


typedef struct {
  char	        lasterr_msg [B_ERROR_MSGLENGTH];
  char		lasterr_str [B_LASTERR_STRING];
  b_errtype     lasterr_err;

#ifdef TYPEDEFS_H_INCLUDED
  b_int64       lasterr_par [B_ERROR_NUMPARAMS];
  
#else
  ULONG         lasterr_par [B_ERROR_NUMPARAMS];
  
#endif
  
} b_lasterrtype;


/* --------------------------------------------------------------
   definitions for string lists (pattern parser)
   -------------------------------------------------------------- */
typedef struct {       /* some parameters do have a list of strings as value */
  char *          name;  /* e.g.: lock, unlock, releaselock etc              */
  unsigned long   value;    /* and is represented by this value              */
} b_param_stringlisttype; 

/* the pattern strings are classified into several pattern areas */
#define B_PATT_STD               0x10
#define B_PATT_COND              0x20
#define B_PATT_SQ                0x40
#define B_PATT_TRAN		 0x80


/* --------------------------------------------------------------
   definitions for card communication
   -------------------------------------------------------------- */

/* communcation purposes */
#define B_LENGTH_NEGOTIATE		0xffff


/* --------------------------------------------------------------
   definitions for license handling
   -------------------------------------------------------------- */

/* license codes */
/* codes for scalable resources */

/* !! NOTE !!
   The list of licenses in error.c is related to the bit position in the
   license field. Keep them coherent! */

CLI            /* DEF_START ~G_Capability */
#define B_CAPABILITY_NONE         		0x00000000UL   /* @capnone */
#define B_CAPABILITY_ALL			0xfffff800UL   /* @capall  last byte for h/w */

#define B_CAPABILITY_HARDWARE_MASK		0x000000ffUL   /* reserved */

#define	B_CAPABILITY_TRACEDEPTH_MASK		0x00000f00UL   /* @traceall */
#define	B_CAPABILITY_TRACEDEPTH_SHIFT		8 /* how to shift the mask */

#  define B_CAPABILITY_TRACEDEPTH_NONE		0x00000000UL
#  define B_CAPABILITY_TRACEDEPTH_32k		0x00000100UL
#  define B_CAPABILITY_TRACEDEPTH_64k		0x00000200UL
#  define B_CAPABILITY_TRACEDEPTH_128k		0x00000300UL
#  define B_CAPABILITY_TRACEDEPTH_256k		0x00000400UL
#  define B_CAPABILITY_TRACEDEPTH_512k		0x00000500UL
#  define B_CAPABILITY_TRACEDEPTH_1M		0x00000600UL
#  define B_CAPABILITY_TRACEDEPTH_2M		0x00000700UL
#  define B_CAPABILITY_TRACEDEPTH_4M		0x00000800UL

#define B_CAPABILITY_PERFSEQ_MASK		0x00007000UL
#define B_CAPABILITY_PERFSEQ_SHIFT		12 /* how to shift the mask */

#  define B_CAPABILITY_PERFSEQ_NONE		0x00000000UL
#  define B_CAPABILITY_PERFSEQ_1		0x00001000UL
#  define B_CAPABILITY_PERFSEQ_2		0x00002000UL
#  define B_CAPABILITY_PERFSEQ_3		0x00003000UL
#  define B_CAPABILITY_PERFSEQ_4		0x00004000UL
#  define B_CAPABILITY_PERFSEQ_5		0x00005000UL
#  define B_CAPABILITY_PERFSEQ_6		0x00006000UL
#  define B_CAPABILITY_PERFSEQ_8		0x00007000UL

/* codes for ASIC resources */
#define B_CAPABILITY_CAPI         		0x00010000UL 
#define B_CAPABILITY_ANALYZER     		0x00020000UL
#define B_CAPABILITY_EXERCISER    		0x00040000UL
#define B_CAPABILITY_HOSTINT      		0x00080000UL
#define B_CAPABILITY_64_BIT       		0x00100000UL
#define B_CAPABILITY_66_MHZ_AN    		0x00200000UL
#define B_CAPABILITY_66_MHZ_EX    		0x00400000UL
#define B_CAPABILITY_TIMING       		0x00800000UL

/* codes for additional excecution engines */
#define B_CAPABILITY_SST          		0x01000000UL 
#define B_CAPABILITY_PPR          		0x02000000UL

#define B_CAPABILITY_RESIDENT			0x80000000UL

CLI                /* DEF_END */

/* locking classes */
#define B_LOCK_NONE			0x00000000UL
#define B_LOCK_MAILBOX			0x00000001UL
#define B_LOCK_CPUPORT			0x00000002UL

#define B_LOCK_EXERCISER		0x00000010UL

#define B_LOCK_TRACE			0x00000100UL
#define B_LOCK_PROTOCOL			0x00000200UL
#define B_LOCK_PERFORMANCE		0x00000400UL
#define B_LOCK_ANALYZER			0x00000700UL

#define B_LOCK_PATTERN(pat)		(0x00000800UL + ((pat & 0xff) << 24))

#define B_LOCK_SST			0x00010000UL

#define B_LOCK_READ_ALLOWED_HI		0x40000000UL
#define B_LOCK_READ_ALLOWED_LO		0x80000000UL


#define B_LOCK_BOARD			(B_LOCK_MAILBOX | B_LOCK_CPUPORT | \
					 B_LOCK_EXERCISER | B_LOCK_ANALYZER | \
					 B_LOCK_SST)

/* --------------------------------------------------------------------------
 * b_blockiorestype defines those onboard resources that can be accessed
 * in block io mode.  
 * -------------------------------------------------------------------------- */
   
CLI typedef enum {
  B_BIO_UNKNOWN,
  B_BIO_TRACEMEM,
  B_BIO_DATA_MEM,
  B_BIO_CPU_PORT0,
  B_BIO_CPU_PORT1
} b_blockiorestype;


#endif


